import javax.swing.*;
import java.awt.event.*;

public class Aplikacja extends JFrame {
  private JComboBox<String> cmb;
  private JTextField textField;
  private JLabel label;
  private JButton buttonDel, buttonAdd;
  
  public Aplikacja() {
    ActionListener al = new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        if(e.getSource() == cmb){
          int itemIndex = cmb.getSelectedIndex();
          if(itemIndex < 1){
            return;
          }
          String itemText = cmb.getSelectedItem().toString();
          label.setText(itemText);
        }
        else if(e.getSource() == buttonDel){
          if(cmb.getSelectedIndex() > 0){
            cmb.removeItemAt(cmb.getSelectedIndex());
          }
        }
        else if(e.getSource() == buttonAdd){
          cmb.addItem(textField.getText());
        }
      }
    };

    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setLayout(null);

    label = new JLabel("Wybierz pozycj z listy.");
    label.setBounds(80, 10, 170, 20);

    buttonAdd = new JButton("Dodaj element");
    buttonAdd.setBounds(80, 100, 170, 20);
    buttonAdd.addActionListener(al);
    
    buttonDel = new JButton("Usu wybrany element");
    buttonDel.setBounds(80, 130, 170, 20);
    buttonDel.addActionListener(al);
    
    textField = new JTextField();
    textField.setBounds(80, 70, 170, 20);

    cmb = new JComboBox<String>();
    cmb.setBounds (80, 40, 170, 20);
    cmb.addItem("Wybierz ksik...");
    cmb.addItem("Java. wiczenia praktyczne");
    cmb.addItem("Java. wiczenia zaawansowane");
    cmb.addItem("Java. Tablice informatyczne");
    cmb.addItem("Java. Leksykon kieszonkowy");
    cmb.addActionListener(al);

    add(cmb);
    add(label);
    add(buttonAdd);
    add(buttonDel);
    add(textField);

    setSize(340, 200);
    setVisible(true);
  }
  public static void main(String args[]) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new Aplikacja();
      }
    });
  }
}
